<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Daftar Dummy Schedule</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

    <div class="container py-5">
        <h2 class="mb-4 text-center fw-bold">Daftar Dummy Schedule</h2>

        <div class="table-responsive shadow rounded">
            <table class="table table-hover table-striped align-middle mb-0">
                <thead class="table-dark text-center">
                    <tr>
                        <th scope="col">No</th>
                        <th scope="col">No Surat</th>
                        <th scope="col">Tanggal Surat</th>
                        <th scope="col">Mitra</th>
                        <th scope="col">Produk</th>
                        <th scope="col">Detail Produk</th>
                        <th scope="col">Tanggal Mulai</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $schedules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $schedule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td class="text-center"><?php echo e($index + 1); ?></td>
                            <td><?php echo e($schedule->letter_number); ?></td>
                            <td class="text-nowrap">
                                <?php echo e(\Carbon\Carbon::parse($schedule->letter_date)->format('d M Y')); ?>

                            </td>
                            <td><?php echo e($schedule->partner->name ?? '-'); ?></td>
                            <td><?php echo e($schedule->product->name ?? '-'); ?></td>
                            <td>
                                <?php if($schedule->selectedDetails->isNotEmpty()): ?>
                                    <ul class="mb-0 ps-3">
                                        <?php $__currentLoopData = $schedule->selectedDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><?php echo e($detail->name); ?></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                <?php else: ?>
                                    <span class="text-muted">Tidak ada detail</span>
                                <?php endif; ?>
                            </td>
                            <td class="text-nowrap">
                                <?php echo e(\Carbon\Carbon::parse($schedule->started_date)->format('d M Y')); ?>

                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="text-center text-muted">Belum ada data schedule</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php /**PATH E:\laragon\www\dummyerp\resources\views/dummy_schedule.blade.php ENDPATH**/ ?>