<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Daftar Dummy Schedule</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

    <div class="container py-5">
        <h2 class="mb-4 text-center fw-bold">Daftar Dummy Schedule</h2>

        <div class="table-responsive shadow rounded">
            <table class="table table-hover table-striped align-middle mb-0">
                <thead class="table-dark text-center">
                    <tr>
                        <th scope="col">No</th>
                        <th scope="col">No Surat</th>
                        <th scope="col">Tanggal Surat</th>
                        <th scope="col">Mitra</th>
                        <th scope="col">Produk</th>
                        <th scope="col">Detail Produk</th>
                        <th scope="col">Tanggal Mulai</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse ($schedules as $index => $schedule)
                        <tr>
                            <td class="text-center">{{ $index + 1 }}</td>
                            <td>{{ $schedule->letter_number }}</td>
                            <td class="text-nowrap">
                                {{ \Carbon\Carbon::parse($schedule->letter_date)->format('d M Y') }}
                            </td>
                            <td>{{ $schedule->partner->name ?? '-' }}</td>
                            <td>{{ $schedule->product->name ?? '-' }}</td>
                            <td>
                                @if ($schedule->selectedDetails->isNotEmpty())
                                    <ul class="mb-0 ps-3">
                                        @foreach ($schedule->selectedDetails as $detail)
                                            <li>{{ $detail->name }}</li>
                                        @endforeach
                                    </ul>
                                @else
                                    <span class="text-muted">Tidak ada detail</span>
                                @endif
                            </td>
                            <td class="text-nowrap">
                                {{ \Carbon\Carbon::parse($schedule->started_date)->format('d M Y') }}
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="text-center text-muted">Belum ada data schedule</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
