<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\DummySchedule;
use App\Models\DummyPartner;
use App\Models\DummyProduct;
use App\Models\DummyDetailProduct;
use Carbon\Carbon;

class DummyScheduleSeeder extends Seeder
{
    public function run(): void
    {
        $data = [
            // 15 data asli
            [
                "no_surat" => "001/BL-INS/IX/2025",
                "tgl_surat" => "2025-09-01",
                "mitra" => "PT Bunga Laut",
                "lokasi" => "Jl. Pelabuhan No. 1, Surabaya",
                "produk" => "MV Nusantara Jaya (Kapal Kargo)",
                "detail_produk" => [
                    "Kondisi Lambung",
                    "Mesin Induk",
                    "Sistem Navigasi",
                    "Peralatan Keselamatan",
                    "Dokumen Kapal"
                ]
            ],
            [
                "no_surat" => "002/GP/IX/2025",
                "tgl_surat" => "2025-09-02",
                "mitra" => "CV Gula Prima",
                "lokasi" => "Jl. Industri Gula No. 5, Gresik",
                "produk" => "Gula Kristal Putih",
                "detail_produk" => [
                    "Kadar Sukrosa",
                    "Warna ICUMSA",
                    "Kadar Air",
                    "Butiran Kristal",
                    "Kebersihan Kemasan"
                ]
            ],
            [
                "no_surat" => "EM-003/IX/2025",
                "tgl_surat" => "2025-09-03",
                "mitra" => "PT Energi Mandiri",
                "lokasi" => "Kawasan Pembangkit Gas, Cilegon",
                "produk" => "Generator Turbin Gas",
                "detail_produk" => [
                    "Kebersihan Filter",
                    "Konsumsi Bahan Bakar",
                    "Output Daya",
                    "Sistem Pendingin",
                    "Panel Kontrol"
                ]
            ],
            [
                "no_surat" => "004/CSL/IX/2025",
                "tgl_surat" => "2025-09-04",
                "mitra" => "CV Sawit Lestari",
                "lokasi" => "Desa Sungai Riau, Kalimantan Tengah",
                "produk" => "CPO (Crude Palm Oil)",
                "detail_produk" => [
                    "Kadar FFA",
                    "Moisture",
                    "Kadar Kotoran",
                    "Warna",
                    "Bau"
                ]
            ],
            [
                "no_surat" => "BBN/005/IX/25",
                "tgl_surat" => "2025-09-05",
                "mitra" => "PT Batu Bara Nusantara",
                "lokasi" => "Site Tambang, Kutai Kartanegara, Kaltim",
                "produk" => "Batubara Kalori Tinggi",
                "detail_produk" => [
                    "Nilai Kalori",
                    "Kadar Abu",
                    "Kadar Sulfur",
                    "Kelembapan",
                    "Ukuran Butir"
                ]
            ],
            [
                "no_surat" => "006/IJ/IX/2025",
                "tgl_surat" => "2025-09-06",
                "mitra" => "PT Industri Baja Jaya",
                "lokasi" => "Kawasan Industri Krakatau Steel, Cilegon",
                "produk" => "Baja Tulangan (Rebar)",
                "detail_produk" => [
                    "Diameter",
                    "Kekuatan Tarik",
                    "Kandungan Karbon",
                    "Sertifikat Uji",
                    "Karat/Defect"
                ]
            ],
            [
                "no_surat" => "007/AMDK/IX/2025",
                "tgl_surat" => "2025-09-07",
                "mitra" => "PT Aqua Segar",
                "lokasi" => "Pabrik AMDK, Sukabumi",
                "produk" => "Air Mineral Botol 600ml",
                "detail_produk" => [
                    "pH",
                    "TDS",
                    "Kejernihan",
                    "Kadar Mikroba",
                    "Kemasan Segel"
                ]
            ],
            [
                "no_surat" => "008/KOPI/IX/2025",
                "tgl_surat" => "2025-09-08",
                "mitra" => "CV Kopi Sejati",
                "lokasi" => "Pabrik Kopi Toraja, Sulawesi Selatan",
                "produk" => "Kopi Arabika Toraja",
                "detail_produk" => [
                    "Kadar Air",
                    "Ukuran Biji",
                    "Warna Sangrai",
                    "Aroma",
                    "Uji Cupping"
                ]
            ],
            [
                "no_surat" => "TS-009/IX/2025",
                "tgl_surat" => "2025-09-09",
                "mitra" => "PT Tekstil Sejahtera",
                "lokasi" => "Kawasan Tekstil, Bandung",
                "produk" => "Kain Katun",
                "detail_produk" => [
                    "Kerapatan Benang",
                    "Warna",
                    "Ketahanan Luntur",
                    "Ketebalan",
                    "Kualitas Jahitan"
                ]
            ],
            [
                "no_surat" => "010/MEA/IX/2025",
                "tgl_surat" => "2025-09-10",
                "mitra" => "PT Migas Energi Abadi",
                "lokasi" => "Terminal BBM, Balikpapan",
                "produk" => "Minyak Solar Industri",
                "detail_produk" => [
                    "Kandungan Sulfur",
                    "Viskositas",
                    "Flash Point",
                    "Warna",
                    "Kandungan Air"
                ]
            ],
            [
                "no_surat" => "011/CPM/IX/2025",
                "tgl_surat" => "2025-09-11",
                "mitra" => "CV Pangan Makmur",
                "lokasi" => "Pabrik Tepung, Bogor",
                "produk" => "Tepung Terigu",
                "detail_produk" => [
                    "Kadar Protein",
                    "Warna",
                    "Kadar Air",
                    "Granulasi",
                    "Keamanan Pangan (BPOM)"
                ]
            ],
            [
                "no_surat" => "PSR/012/IX/25",
                "tgl_surat" => "2025-09-12",
                "mitra" => "PT Perkapalan Samudra Raya",
                "lokasi" => "Galangan Kapal, Batam",
                "produk" => "Kapal Tugboat TB Samudra 05",
                "detail_produk" => [
                    "Mesin Utama",
                    "Sistem Kemudi",
                    "Radio Komunikasi",
                    "Sekoci",
                    "Sertifikat Docking"
                ]
            ],
            [
                "no_surat" => "013/FP/IX/2025",
                "tgl_surat" => "2025-09-13",
                "mitra" => "PT Farmasi Prima",
                "lokasi" => "Kawasan Farmasi, Bekasi",
                "produk" => "Obat Tablet Paracetamol 500mg",
                "detail_produk" => [
                    "Dosis",
                    "Tanggal Kedaluwarsa",
                    "Kemasan",
                    "Kualitas Bahan Aktif",
                    "Sertifikasi BPOM"
                ]
            ],
            [
                "no_surat" => "014/PU/IX/2025",
                "tgl_surat" => "2025-09-14",
                "mitra" => "CV Padi Unggul",
                "lokasi" => "Gudang Beras, Karawang",
                "produk" => "Beras Premium",
                "detail_produk" => [
                    "Kadar Air",
                    "Butir Patah",
                    "Warna",
                    "Aroma",
                    "Kadar Menir"
                ]
            ],
            [
                "no_surat" => "MU-015/IX/2025",
                "tgl_surat" => "2025-09-15",
                "mitra" => "PT Mineral Utama",
                "lokasi" => "Tambang Nikel, Morowali",
                "produk" => "Bijih Nikel",
                "detail_produk" => [
                    "Kadar Ni",
                    "Moisture",
                    "Ukuran Butir",
                    "Kadar Fe",
                    "Kandungan Unsur Lain"
                ]
            ],

            // 5 data tambahan
            [
                "no_surat" => "016/BL-INS/IX/2025",
                "tgl_surat" => "2025-09-16",
                "mitra" => "PT Bunga Laut 2",
                "lokasi" => "Jl. Pelabuhan No. 2, Surabaya",
                "produk" => "MV Nusantara Jaya (Kapal Kargo)",
                "detail_produk" => [
                    "Lampu Navigasi",
                    "Alat Pemadam Kebakaran",
                    "Dokumen Kapal",
                    "Mesin Cadangan",
                    "Radio VHF"
                ]
            ],
            [
                "no_surat" => "017/GP/IX/2025",
                "tgl_surat" => "2025-09-17",
                "mitra" => "CV Gula Prima 2",
                "lokasi" => "Jl. Industri Gula No. 10, Gresik",
                "produk" => "Gula Kristal Putih",
                "detail_produk" => [
                    "Kadar Sukrosa",
                    "Kadar Kotoran",
                    "Kadar Air",
                    "Butiran Kristal",
                    "Kebersihan Kemasan"
                ]
            ],
            [
                "no_surat" => "018/EM/IX/2025",
                "tgl_surat" => "2025-09-18",
                "mitra" => "PT Energi Mandiri 2",
                "lokasi" => "Kawasan Pembangkit Listrik, Cilegon",
                "produk" => "Generator Turbin Gas",
                "detail_produk" => [
                    "Output Daya",
                    "Sistem Pendingin",
                    "Panel Kontrol",
                    "Konsumsi Oli",
                    "Kebersihan Panel"
                ]
            ],
            [
                "no_surat" => "019/CSL/IX/2025",
                "tgl_surat" => "2025-09-19",
                "mitra" => "CV Sawit Lestari 2",
                "lokasi" => "Desa Sungai Riau, Kalteng",
                "produk" => "CPO (Crude Palm Oil)",
                "detail_produk" => [
                    "Kadar Asam",
                    "Kadar Air",
                    "Warna Minyak",
                    "Bau",
                    "Kandungan Impurities"
                ]
            ],
            [
                "no_surat" => "020/KOPI/IX/2025",
                "tgl_surat" => "2025-09-20",
                "mitra" => "CV Kopi Sejati 2",
                "lokasi" => "Pabrik Kopi Toraja, Sulsel",
                "produk" => "Kopi Arabika Toraja",
                "detail_produk" => [
                    "Ukuran Biji",
                    "Kadar Air",
                    "Warna Sangrai",
                    "Aroma",
                    "Uji Rasa"
                ]
            ],
        ];

        // mulai dari 22 September 2025
        $startDate = Carbon::create(2025, 9, 22);

        foreach ($data as $index => $item) {
            $partner = DummyPartner::firstOrCreate(
                ['name' => $item['mitra']],
                ['address' => $item['lokasi']]
            );

            $product = DummyProduct::firstOrCreate(['name' => $item['produk']]);

            $schedule = DummySchedule::create([
                'letter_number' => $item['no_surat'],
                'letter_date'   => $item['tgl_surat'],
                'partner_id'    => $partner->partner_id,
                'product_id'    => $product->product_id,
                'started_date'  => $startDate->copy()->addDays($index)->format('Y-m-d'),
            ]);

            foreach ($item['detail_produk'] as $detailName) {
                $detail = DummyDetailProduct::firstOrCreate([
                    'product_id' => $product->product_id,
                    'name' => $detailName
                ]);
                $schedule->selectedDetails()->attach($detail->detail_id);
            }
        }
    }
}
