<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('dummy_schedule_details', function (Blueprint $table) {
            $table->unsignedBigInteger('schedule_id');
            $table->unsignedBigInteger('detail_id');

            $table->foreign('schedule_id')
                ->references('schedule_id')
                ->on('dummy_schedules')
                ->onDelete('cascade');

            $table->foreign('detail_id')
                ->references('detail_id')
                ->on('dummy_detail_products')
                ->onDelete('cascade');

            $table->primary(['schedule_id', 'detail_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('dummy_schedule_details');
    }
};
