<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('dummy_detail_products', function (Blueprint $table) {
            $table->id('detail_id');
            $table->unsignedBigInteger('product_id');
            $table->string('name');
            $table->timestamps();

            $table->foreign('product_id')
                ->references('product_id')
                ->on('dummy_products')
                ->onDelete('cascade');
            $table->index('product_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('dummy_detail_products');
    }
};
