<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class DummySchedule extends Model
{
    use HasFactory;

    protected $table = 'dummy_schedules';
    protected $primaryKey = 'schedule_id';
    public $incrementing = true;
    protected $keyType = 'int';

    protected $fillable = [
        'letter_number',
        'letter_date',
        'partner_id',
        'product_id',
        'started_date',
    ];

    protected $casts = [
        'letter_date'  => 'date',
        'started_date' => 'date',
        'created_at'   => 'datetime',
        'updated_at'   => 'datetime',
    ];

    public function partner()
    {
        return $this->belongsTo(DummyPartner::class, 'partner_id', 'partner_id');
    }

    public function product()
    {
        return $this->belongsTo(DummyProduct::class, 'product_id', 'product_id');
    }

    public function selectedDetails()
    {
        return $this->belongsToMany(
            DummyDetailProduct::class,
            'dummy_schedule_details',
            'schedule_id',
            'detail_id'
        );
    }
}
