<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class DummyProduct extends Model
{
    use HasFactory;

    protected $table = 'dummy_products';
    protected $primaryKey = 'product_id';

    protected $fillable = [
        'name',
        'created_by'
    ];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    public function details()
    {
        return $this->hasMany(DummyDetailProduct::class, 'product_id', 'product_id');
    }
}
