<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class DummyDetailProduct extends Model
{
    use HasFactory;

    protected $table = 'dummy_detail_products';
    protected $primaryKey = 'detail_id';

    protected $fillable = [
        'product_id',
        'name',
    ];

    public function product()
    {
        return $this->belongsTo(DummyProduct::class, 'product_id', 'product_id');
    }

    public function schedules()
    {
        return $this->belongsToMany(DummySchedule::class, 'schedule_details', 'detail_id', 'schedule_id');
    }
}
