<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\DummySchedule;

class DummyScheduleController extends Controller
{
    public function index()
    {
        $schedules = DummySchedule::with(['partner', 'product', 'selectedDetails'])->get();
        return view('dummy_schedule', compact('schedules'));
    }

    public function showByLetterNumber($no_surat)
    {
        $jadwal = DummySchedule::with(['partner', 'product', 'selectedDetails'])
            ->where('letter_number', $no_surat)
            ->first();

        if (!$jadwal) {
            return response()->json(['error' => 'Data tidak ditemukan'], 404);
        }

        return response()->json([
            'letter_number' => $jadwal->letter_number,
            'letter_date'   => $jadwal->letter_date ? $jadwal->letter_date->format('Y-m-d') : null,
            'partner_name'  => $jadwal->partner ? $jadwal->partner->name : null,
            'partner_address' => $jadwal->partner ? $jadwal->partner->address : null,
            'started_date' => $jadwal->started_date ? $jadwal->started_date->format('Y-m-d') : null,
            'product_name'  => $jadwal->product ? $jadwal->product->name : null,
            'product_details' => $jadwal->selectedDetails->pluck('name')->toArray(),
        ]);
    }
}
